/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Gfx  ground;
Mshg mshg; // here Mshg (mesh group) is used instead of Mesh (single mesh)
/******************************************************************************/
void InitPre()
{
   App.name="Terrain";
   App.flag=APP_MS_EXCLUSIVE|APP_FULL_TOGGLE;
   IOPath="../data/";
   PakAdd("engine.pak");

   D.full(true).ambPower(0.3).shdSoft(1);
   ViewportFull.range=40;
}
/******************************************************************************/
void CreateMesh(Mesh &mesh)
{
   // create random terrain heightmap
   Gfx gfx(128,128,1,GFX_I8,GFX_SOFT);
   REPD(y,gfx.y())
   REPD(x,gfx.x())gfx.pixel(x,y,Rnd(256)); // software images don't need to be locked/unlocked
   gfx.blur(5,false);                      // apply gaussian blur to the heightmap with 5 pixel range and no clamping

   // create terrain Mesh
   mesh.create(1).B(0).createPlane(128,128,VTX_TX0); // create 2D plane with 128x128 vertexes
   mesh.B(0).texScale(Vec2(16));                     // scale texture coordinates
   mesh.B(0).displaceZ(gfx);                         // displace vertexes Z from heightmap
   mesh.swapYZ();                                    // swap vertexes Y with Z
   mesh.matrix(Matrix().setPos(Vec(-0.5,-0.6,-0.5)).scale(Vec(50,8,50))); // transform by matrix
   mesh.setNormals();                                // recalculate normals
   mesh.setMaterial(Materials("mtrl/grass/0.mtrl")); // set material
   mesh.setBox();                                    // set bounding box
}
/******************************************************************************/
Bool Init()
{
   Cam.at.y+=2; // move camera up

   Sun.set(*Gfxs("gfx/sky/sun.gfx")); // sun
   Sky.set();                         // sky

   // create mesh
   Mesh mesh;
   CreateMesh(mesh);

   // create terrain Mshg from standard Mesh
   mshg.create(mesh,VecI(5,1,5)); // create Mshg with 5x1x5 (5*1*5=25) splits (Mesh is splitted to 25 parts along axises)
   mshg.setRender();

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.01f,10,CAMH_ZOOM|(Ms.b(1) ? CAMH_MOVE : CAMH_ROT));
   return true;
}
/******************************************************************************/
void Render()
{
   switch(Renderer())
   {
      case RM_SOLID:
         mshg.draw();
      break;
   }
}
void Draw()
{
   Renderer(Render);
   if(Kb.b(KB_SPACE))REP(mshg.num)mshg.M(i).box.draw(); // draw mesh bounding boxes
}
/******************************************************************************/
